/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.api.features.IGridLinkableHandler;
import com.google.common.base.Preconditions;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

@ThreadSafe
public final class GridLinkables {
    private static final Map<Item, IGridLinkableHandler> registry = new IdentityHashMap<Item, IGridLinkableHandler>();

    private GridLinkables() {
    }

    public static synchronized void register(ItemLike itemLike, IGridLinkableHandler handler) {
        Objects.requireNonNull(itemLike, "itemLike");
        Objects.requireNonNull(itemLike.m_5456_(), "itemLike.asItem()");
        Objects.requireNonNull(handler, "handler");
        Item item = itemLike.m_5456_();
        Preconditions.checkState((!registry.containsKey(item) ? 1 : 0) != 0, (String)"Handler for %s already registered", (Object)item);
        registry.put(item, handler);
    }

    @Nullable
    public static synchronized IGridLinkableHandler get(ItemLike itemLike) {
        Objects.requireNonNull(itemLike, "itemLike");
        Objects.requireNonNull(itemLike.m_5456_(), "itemLike.asItem()");
        return registry.get(itemLike.m_5456_());
    }
}

